################################################################################
##   Mod Overview and Description
################################################################################
#modname "Antilarium"
#version 4.01
#domversion 3.23
#icon "./Antilarium/Antilarium.tga"

#description "Special monsters and magic sites for the Antilarium 4 map.  Guaranteed compatible with the Mytheology mod!  Don't try to play the Antilarium map without this mod activated!  On the other hand, if you just install this mod without playing Antilarium, much of its content will never be activated.

Creator: Psientist
Updated: 3/14/09"


################################################################################
##   Custom Monsters
################################################################################

--------------------------------------------------------------------------------
#newmonster 2800 -- 2000
#name "Thermovore"
#descr "A mysterious, magical and dangerous creature of the frozen wastes that feeds on the heat of the living."
#spr1 "./Antilarium/snowflake1.tga"
#spr2 "./Antilarium/snowflake2.tga"
#hp 5
#gcost 20
#rcost 7
#str 2
#prot 0
#att 10
#mor 30
#def 10
#mr 8
#prec 14
#enc 0
#ap 12
#mapmove 0
#neednoteat
#magicbeing
#blind
#mindless
#ethereal
#cold
#coldpower 2
#winterpower 1
#coldres 200
#poisonres 50
#neednoteat
#fireres -25
#itemslots 1
#flying
#weapon 384 -- minor life drain
--weapon 409 -- small area cold
#size 1
#end


--------------------------------------------------------------------------------
#newmonster 2801 
#name "Shiro Warrior"
#descr "A great, humanoid, feline warrior with the ferocity and markings of lions and tigers.  They are ferocious fighters, and deadly swift and agile in combat.  They are also naturally alert, silent, and stealthy, and excel at both patrolling and slipping through provinces unseen.  Although renowned for their fighting skills, these creatures are dwindling in number and rarely seen outside of the westernmost islands."
#spr1 "./Antilarium/shiro1.tga"
#spr2 "./Antilarium/shiro2.tga"
#gcost 30
#rcost 16
#hp 18
#str 14
#prot 5
#att 14
#mor 13
#def 18
#mr 12
#prec 12
#enc 2
#ap 16
#mapmove 2
#nametype 141
#darkvision 30
#forestsurvival
#stealthy
#coldres 25
#mountainsurvival
#weapon 11 -- Great Sword
#armor "Full Scale Mail"
#size 3
#patrolbonus 5
#end
--------------------------------------------------------------------------------
#newmonster 2845 
#name "Shiro Noble"
#descr "A great, humanoid, feline warrior with the ferocity and markings of lions and tigers.  Shiro nobility are by heredity stronger and faster than normal shiro.  They are ferocious fighters, and deadly swift and agile in combat.  They are also naturally alert, silent, and stealthy, and excel at both patrolling and slipping through provinces unseen.  Although renowned for their fighting skills, these creatures are dwindling in number and rarely seen outside of the westernmost islands."
#spr1 "./Antilarium/kyrrn1.tga"
#spr2 "./Antilarium/kyrrn2.tga"
#gcost 80
#rcost 30
#hp 25
#str 15
#prot 5
#att 14
#mor 15
#def 18
#mr 12
#prec 12
#enc 2
#ap 17
#mapmove 2
#nametype 141
#darkvision 30
#forestsurvival
#stealthy
#coldres 25
#mountainsurvival
#weapon 11 -- Great Sword
#armor "Full Scale Mail"
#goodleader
#noundeadleader
#nomagicleader
#itemslots 13446
#size 3
#patrolbonus 10
#end





--------------------------------------------------------------------------------
-- Agony Disciple
#newweapon 700
#name "Athame of Maiming"
#dmg 5
#nratt 1
#secondaryeffect 125 -- cripplage
#end
--------------------------------------------------------------------------------
#newmonster 2803
#name "Agony Disciple"
#descr "A fanatic disciple of the Goddess of Pain, this human has tortured his own body and mind to the absolute limits of endurance to gain enlightenment and purity.  While his body is left scarred and maimed from the extremity of his devotions, he has gained insight and revelation into life and how to cause injury, and has transcended the ability to feel fear or his own wounds.  In battle, Agony Disciples are known to cut strips of flesh from their own body in order to horrify and dismay their opponents."
#spr1 "./Antilarium/agonydisciple1.tga"
#spr2 "./Antilarium/agonydisciple2.tga"
#gcost 25
#rcost 10
#hp 18
#str 9
#prot 2
#att 18
#mor 13
#def 10
#mr 18
#prec 18
#enc 3
#ap 10
#mapmove 2
#beserk 2
#poisonres 25
#shockres 25
#regeneration 3
#fear 0
#nametype 100
#incunrest 1
#douse 1
#reinvigoration 1
#onebattlespell "Agony"
#holy
#startaff 50
#weapon 700 -- athame 
#weapon 40 -- whip
#armor "robes"
#size 2
#end



----------------------------------------------------------------------------
#newmonster 2804
#name "Trollfiend"
#descr "A bizarre and horrific monster that was crafted by the Usurper from raw magics and hapless travellers in order to guard his citidel of magic."
#spr1 "./Antilarium/towerfiend1.tga"
#spr2 "./Antilarium/towerfiend2.tga"
#gcost 150
#rcost 40
#hp 70
#str 22
#att 14
#def 12
#prec 8
#ap 14
#mapmove 1
#prot 10
#mor 30
#mr 18
#enc 1
#mapmove 1
#noleader
#nomagicleader
#noundeadleader
#scockres 50
#coldres 50
#pooramphibian
#regeneration 15
#magicbeing
#mindless
#reinvigoration 5
#weapon "Venomous Claw"
#weapon "Venomous Claw"
#maxage 999
#end



--------------------------------------------------------------------------------
-- Cloud Monk / Storm Monk
#newweapon 699
#name "Gale Fist"
#dmg 3
#nratt 2
#att 2
#def 2
#dt_normal
#armorpiercing
#sound 11
#end

#newweapon 698
#name "Thunder Fist"
#dmg 10
#nratt 1
#att 3
#def 2
#dt_normal
#armorpiercing
#magic
#sound 11
--secondaryeffect 306
#end


#newweapon 704
#name "Meridian Strike"
#dmg 1
#nratt 1
#att 0
#def 0
#dt_paralyze
#bonus
#sound 11
#end

----------------------------------------
#newmonster 2805 -- 1995
#name "Cloud Monk"
#descr "The Cloud Monks are members of a secret monastic warrior sect that seek enlightenment through severe aesceticism, intense meditation and discipline, and exposure to the elements.  Acolytes become recognized as a full monk when they achieve a level of spiritual and physical mastery that transforms their bodies into living weapons.  However, the monks are not warlike, and seek only to be left alone to pursue their training and contemplation.  Their monasteries can only be found on the most remote and stormy mountain peaks."
#spr1 "./Antilarium/cloudmonk1.tga"
#spr2 "./Antilarium/cloudmonk2.tga"
#hp 20
#gcost 30
#rcost 18
#str 11
#prot 6
#att 13
#mor 14
#def 12
#mr 13
#prec 16
#enc 2
#ap 14
#mapmove 3
#poisonres -25
#shockres 25
#coldres 25
#fireres 25
#heal
#reinvigoration 1
#weapon 699
#weapon 699  
#armor "robes"
#size 2
#noundeadleader
#nomagicleader
#poorleader
#mountainsurvival
#end




---------------------------------
#newmonster 2806
#name "Storm Master"
#descr "The Cloud Monks are members of a secret monastic warrior order that seek enlightenment through severe aesceticism, intense meditation and discipline, and exposure to the elements.  Acolytes become recognized as a full monk when they achieve a level of spiritual and physical mastery that transforms their bodies into living weapons.  However, the monks are not warlike, and seek only to be left alone to pursue their training and contemplation.  Their monasteries can only be found on the most remote and stormy mountain peaks.  Only the most senior, wise, gifted and experienced of all Cloud Monks ever attain the level of perfection which is recognized by the title of Storm Master."
#spr1 "./Antilarium/stormmonk1.tga"
#spr2 "./Antilarium/stormmonk2.tga"
#hp 40
#str 14
#prot 10
#att 14
#mor 30
#def 16
#mr 18
#prec 18
#enc 1
#ap 15
#mapmove 3
#poisonres -25
#shockres 50
#coldres 50
#fireres 50
#heal
#holy
#regeneration 1
#reinvigoration 5
#weapon "Thunder Fist" --  
#weapon "Thunder Fist" --  
#weapon 704 -- stun strike
#armor "robes"
#size 2
#noundeadleader
#nomagicleader
#expertleader
#supplybonus 50
#maxage 999
#mountainsurvival
#end


--------------------------------------------------------------------------------
#newmonster 2807 
#name "Sea Ranger"
#descr "The Sea Ranger is a master of sailing and the open ocean.  He is a daughty figher in maritime environments, and each Sea Range collects some small magical trinket or spell which enables him to survive temporarily beneath the waves.  Sea Rangers are very resourceful, and can navigate in almost any weather and can gather resources whenever they are near the sea.  However, they are famous spendthrifts, and have a reputation for excessive appreciation for ale, song, anf friendship; their love of the sea is surpassed only by the love for pleasures of port."
#spr1 "./Antilarium/searanger1.tga"
#spr2 "./Antilarium/searanger2.tga"
#hp 18
#gcost 20
#rcost 10
#str 10
#prot 1
#att 13
#mor 13
#def 12
#mr 12
#prec 15
#enc 3
#ap 12
#mapmove 3
#poisonres 25
#sailing
#neednoteat -- foragers
#pooramphibian -- inbuilt spells?
#weapon  452 -- harpoon 
#weapon 6 -- short sword
#armor "Full Leather Armor" -- 15 -- full leather 
#armor "Leather Cap" -- 120 -- leather cap
#size 2
#onebattlespell "Twist Fate"
#stormpower 1
#sailing
#end


----------------------------------------------------------------------------
#newmonster 2839
#copystats 219 -- swordsman - tougher and cheaper, well recruit
#name "Weavework Warrior"
#descr "While still adventuring, the hero Cuscraid developed a novel method of fighting which gave him an unprecedented ability to swordfight against multiple opponents.  He called his art 'Weavework', as it gave him and his students extra attacks in combat by 'weaving' their opponents' attacks together.  Now, only one school of Weavework remains, but it continues to produce some of the most skilled warriors in the world."
#spr1 "./Antilarium/weavesword1.tga"
#spr2 "./Antilarium/weavesword2.tga"
#hp 18
#gcost 18
#mor 13
#rcost 12
#str 12
#att 12
#def 12
#def 14
#mr 12
#prec 14
#enc 3
#ap 14
#armor "Half Helmet"
#armor "Plate Cuirass"
#mapmove 3
#weapon 106
#end 







################################################################################
##   Custom Well Guardian Heroes
################################################################################
--------------------------------------------------------------------------------
-- Agony Saint
#newweapon 697
#name "Spade of Divine Offense"
#att 2
#def 2
#dmg 10
#magic
#len 3
#nratt 1
#twohanded
#secondaryeffect 125 -- cripplage
#dt_holy
#end

#newitem
#copyitem 274 -- "The Ark"
#name "The Codex of Life"
#copyspr 314 -- "Igor Knhelm's Tome"
#constlevel 10
#mainpath 5
#type 8 -- misc
#descr "This book was written by the gods, and is said to contain all the knowledge and secrets for the creation and destruction of Life.  Its mere presence will cause non-sacred units to suffer, and for the their very lifeforce to slowy escape from their bodies in a horrible and excruciating manner."
#end
--------------------------------------
#newmonster 2808
#name "Agony Saint"
#descr "The first and highest disciple of the Goddess of Pain, this evil cleric has tortured his own body and mind to the absolute limits of endurance to gain enlightenment and purity and built a feared cult in the process.  While his body is left scarred and maimed from the extremity of his devotions, he has gained insight and revelation into life and how to cause injury, and has transcended the ability to feel fear or the affliction of his own wounds.  In battle, Agony Disciples are known to cut strips of flesh from their own body in order to horrify and dismay their opponents."
#spr1 "./Antilarium/agonysaint1.tga"
#spr2 "./Antilarium/agonysaint2.tga"
#hp 75
#str 11
#prot 4
#att 18
#mor 30
#def 12
#mr 18
#prec 18
#enc 2
#ap 10
#mapmove 2
#poisonres 50
#shockres 50

#clearmagic
#holy
#magicskill 7 6 -- blood
#magicskill 8 3 -- priest
#magicskill 0 3 -- fire
#gemprod 7 1 -- blood

#regeneration 20
#fear 1
#nametype 100
#incunrest 1
#douse 1
#reinvigoration 1
#onebattlespell "Agony"
#startaff 50
#armor "robes"
#size 2
#supplybonus 100
#weapon 697
#goodleader
#goodmagicleader
#goodundeadleader
#maxage 999
#unique
#end




--------------------------------------------------------------------------------
-- Fabillo
#newweapon 696
#name "Ring of Ramming"
#att 2
#def 0
#dmg 15
#magic
#len 0
#nratt 1
#secondaryeffect 91 --stun
#end

#newitem
#copyitem 151
#name "Torc of the Exile"
#copyspr "Slave Collar"
#constlevel 10
#mainpath 5
#mainlevel 10
#type 8 -- misc
#descr "One of the three pieces of the broken soul of Dergoth the Exile, a defeated demigod.  It was generally considered the most dangerous of the three since it contained the Exile's intellect and will, and would quickly enslave any who wore it.  However, powerful binding spells have nullified most of its power and while they remain it will seem little more than a powerless trinket."
#end
--------------------------------------
#newmonster 2809
#name "Mage-Priest of Speed"
#descr "Fabillo was a mage-priest of aspects of speed and quickening in all pantheons of gods.  He studied ways of increasing the flow of time in combat, and was an initiate of the White Towers, a secret society of adventurers dedicated to collecting and sequestering the most vile and harmful magical artifacts and keeping them from the hands of evil.  He wields a magic ring that punches with the force of a battering ram.  He betrayed the Usurper to steal from him one of the three artifacts that contains the broken soul of Dergoth the Exile, and it is his task to guard it lest the artifacts be rejoined and Dergoth return."
#copyspr 302 -- waizard
#hp 75
#mor 30
#mr 18
#def 18
#att 12
#def 11
#prot 0
#ap 20
#mapmove 4
#enc 2
#prec 14

#magicskill 2 4 -- water
#magicskill 4 4 -- mag_astral
#magicskill 1 4 -- mag_air
#gemprod 2 1
#reinvigoration 5
#patrolbonus 5
#siegebonus 10
#supplybonus 100
#heal
#holy
#onebattlespell 401 --"Quickening"
#okleader
#goodmagicleader
#noundeadleader
#weapon 696
#maxage 9999
#unique
#end

--------------------------------------------------------------------------------
-- Winterking
#newmonster 2810
#name "Winterking"
#descr "An ancient demigod, the Winterking waits in his palace in the great Frozen Wastes to spread ice across all the lands, freezing the world in still, icy, unforgiving beauty."
#mor 30
#copyspr 1561 -- father of winters pretender

#hp 100
#mor 30
#mr 18
#str 21
#att 14
#def 14
#ap 13
#mapmove 2
#prec 12
#armor "Furs"

#magicskill 2 5 --water
#magicskill 1 5 -- mag_air
#magicskill 5 1 -- death

#gemprod 2 1 -- water
#supplybonus 150
#onebattlespell "Grip of Winter"
#maxage 9999
--summon1 "Thermovore"
#mountainsurvival
#wastesurvival
#coldpower
#cold
#coldres 200
#unique
#end





--------------------------------------------------------------------------------
-- Usurper
#newitem -- new item - gatestone -> eye of exile?
#copyitem 282
#name "Eye of the Exile" 
#copyspr 272 -- eye of the void
#descr "One of the three pieces of the broken soul of Dergoth the Exile, a defeated demigod.  It was generally considered the most powerful of the three since it contained the Exile's ability to bend space and dimension.  However, through arcate rituals the Usurper has drained most of the power from this artifact, leaving it little more than a metal husk."
#constlevel 10
#mainpath 5
#mainlevel 10
#type 8 -- misc
#end

#newarmor 298 
#name "Psypher Crown" 
#prot 16
#def 4
#enc 0
#type 6 -- crown
#end

#newweapon 691
#name "Nimbus Sword" 
#att 0
#def 1
#len 2
#dmg 6
#dt_normal
#explspr 10108
#nratt 1
#bonus
#secondaryeffectalways 185 --lightning swarm
#dt_normal
#magic
#twohanded
#end

--------------------------------------
#newmonster 2811
#copystats 339 -- sorcerer
#name "The Usurper"
#descr "A sorcerer of unbounded ambition, the arch-sorcerer O-Nyean mastered fire, death, and astral magics.  Through craft and cunning, he acquired many ancient artifacts allowing him to teleport, fly, and cast lightning.  He was given the title Usurper when he teleported his entire citidel of magic to the mage-capital of Mitakka in order to overthrow the great world Council of Mages in a direct assault of magic.  Through the invocation of the Injunction, an arcane global enchantment, the Council barely managed to stave off O-Nyean's attack and seal him inside his own citidel, and returned that citidel to whence it came.  There, the Usurper quietly researches, gathers power, and crafts plans for his escape."
#spr1 "./Antilarium/usurper1.tga"
#spr2 "./Antilarium/usurper2.tga"

#att 12
#hp 75
#mor 30
#mr 22
#def 12
#ap 12
#mapmove 3
#prec 16

#clearmagic
#magicskill 4 5 --mag_astral
#magicskill 3 1 -- earth
#magicskill 0 4 -- mag_fire
#fly 

#gemprod 4 1 -- astral
#reinvigoration 5
#maxage 9999
#supplybonus 100
#onebattlespell "Flame Storm" -- 
#poorleader
#excellentmagicleader
#armor "Psypher Crown"
#weapon 691 -- nimbus sword
#unique
#end








--------------------------------------------------------------------------------
-- Cuscraid
#newmonster 2812
--copystats  1340 --Lord of War 
#name "Warrior Avatar"
#descr "Born of BlackTor, Cuscraid was a mighty Warrior who was undefeated in one-on-one combat.  He wields a special rapier and other items which protects him from mages and any kind of magic.  After a long fighting career, his acts of valor and skill caused Shehannon, the Avatar of Warrior Honor, to select Cuscraid as his replacement.  To this day, Cuscraid watches over the affairs of true Warriors in this world, rewarding the virtuous and punishing those without honor."
#spr1 "./Antilarium/cuscraid1.tga"
#spr2 "./Antilarium/cuscraid2.tga"
#hp 100
#str 16
#prot 14
#att 20
#mor 30
#def 20
#mr 23
#prec 18
#enc 2
#ap 14
#mapmove 2 
#mor 30
#size 2

#clearmagic
#supplybonus 100
#maxage 999
#heal
#poisonres -50
#onebattlespell 344 -- quicken self
#expertleader
#noundeadleader
#nomagicleader
#unique
#end


--------------------------------------------------------------------------------
-- Lester 
#newarmor 300 -- newarmor - blademail
#name "Blademail" 
#prot 12
#def 2
#enc 1
#type 5 -- body armor
#end

#newarmor 299 -- newarmor - blademail
#name "Blademail Halfhelm" 
#prot 12
#enc1
#type 6 -- helmy
#end

#newweapon 695 -- newarmor - blademail
#name "Blademail" 
#att 2
#def 4
#dmg 2
#bonus
#dt_normal
#len 0
#end

#newweapon 694 --  - 
#name "Bastard Sword" 
#twohanded
#rcost 5
#dmg 10
#att 2
#def 2
#len 3
#dt_normal
#end


--------------------------------------
#newmonster 2813
---copystats  1340 --Lord of War 
#name "Lester the Bastard"
#descr "Lester was one of the strongest and most famous of the Warriors of the Second Age.  He earned the moniker 'the Bastard' for his relentless and unswerving pursuit of those he set himself against and for his preferred weapon a great bastard sword.  Although not particularly clever, Lester was a peerless fighter and rose to create a university of fighting arts and to lead the Council of Masters, an organization represting the foremost masters of each type of melee weapon.  Lester wears a special magical armor that is laden with razor-sharp blades, making it both an armor and a weapon."
#spr1 "./Antilarium/lester1.tga"
#spr2 "./Antilarium/lester2.tga"
#hp 100
#str 18
#prot 14
#att 18
#mor 30
#def 12
#mr 15
#prec 15
#enc 2
#ap 12
#mapmove 2
#mor 30
#size 2

#clearmagic
#armor "Blademail"  -- blademail
#armor "Blademail Halfhelm"  -- blademail
#weapon 694 -- "Bastard Sword"
#weapon "Blademail"
#supplybonus 100
#maxage 999
#poisonarmor
#onebattlespell 656 -- Panic
#expertleader
#noundeadleader
#nomagicleader
#unique
#end




--------------------------------------------------------------------------------
-- Johann
#newmonster 2814
#copystats "Sea Ranger" -- 
#name "Johann Waverider"
#descr "There was no hero, warrior, king, or mage of note in the Second Age that at one time or another Johann did not sail with, serve with, or fight against.  He was the most famous of the Sea Rangers, and on more than one occasion commanded entire navies.  However, this scruffy, amiable sailor was just as likely to be found with only a small ship and a few comely lasses, and a bagful of silver to his name, which was the only fortune he desired.  Although he himself never sought fortune or power, his words were greatly respected and few dared spite him for the strength of his reputation and determination.  Johann had a fierce hatred of krakens, and a magic ring which allows him to breathe underwater."
#spr1 "./Antilarium/johann1.tga"
#spr2 "./Antilarium/johann2.tga"
#hp 100
#str 14
#prot 12
#att 16
#mor 30
#def 16
#mr 16
#prec 18
#enc 2
#ap 10
#mapmove 3

#poisonres 50
#shockres 25
#coldres 25
#summon1 2807 -- "Sea Ranger"
#amphibian

#supplybonus 100
#maxage 999
#onebattlespell 99 -- "Twist Fate"
#sailing
#unique
#end




--------------------------------------------------------------------------------
-- Natasha
#newmonster 2815
--copystats  346
#name "Bloodwitch"
#descr "A beautiful, dangerous witch born with a half dark-elf heritage.  She manipulates her exotic beauty to manipulate people and gain power.  She specializes in enslaving men's minds, and is ruthless in her efforts to gain power and influence toward her quest to obtain eternal youth.  The rumors that she has made dark pacts with the darkest and oldest of gods earns her a most terrifying reputation."
#copyspr 355
#prot 0
#str 9
#def 10
#att 11
#ap 12
#mapmove 2
#hp 18
#mor 30
#mr 16
#prec 16
#magicskill 7 2 --blood
#maxage 999
#weapon "Athame"
#onebattlespell "Hellbind Heart" --"enslave mind"
#female
#holy
#incunrest 1
#end


--------------------------------------------------------------------------------
-- Gwennheria
#newmonster 2816
#name "Priestess of Fortune"
#descr "The priestess of fortune is held in high respect.  People will travel far to earn the favor of her deity, and tread carefully to not earn her disfavor.  However, there are rumors that her goddess has a darker aspect, and not all those who seek her blessing have noble intentions.  In battle, she can bless her allies with luck.  She is a master of the magics of fortune and luck."
#copyspr 346
#hp 11
#att 10
#def 10
#str 9
#ap 10
#mapmove 2
#prec 16
#mr 15
#prot 0
#mor 30

#magicskill 4 2 -- astral

#maxage 200
#holy
#onebattlespell 404 -- will of the fates
#weapon 366 -- curse luck
#nobadevents 15
#female
#end







--------------------------------------------------------------------------------
-- Bregan
#newweapon 693 --  - blademail
#name "Meteor Whip" 
#twohanded
#rcost 5
#dmg 15
#att 3
#def 1
#len 10
#dt_magic
#armorpiercing
#flail
#sound 9
#end
--------------------------------------
#newmonster 2817
#name "Dwarven Hero"
#descr "Bregan was the foremost dwarven hero of the Second Age.  He is relatively tall for a dwarf - almost four and a half feet, and built both powerful and untiring.  Girded head to foot in magical stone armor, he looked like a well dressed boulder rolling across the battlefield.  Bregan would never look up to meet the eyes of taller races, unless they were close friends or battle comrades; others of 'oversized' races could very well bend down to his level if they wanted to speak with him.  He was also quick to offer to 'shorten them up a bit' if others were not properly respectful.  Bregan was a warrior of few words, and was poor company on long voyages.  Nonetheless he a renowned strategist and his only ambition was to serve his people and renown himself further in battle.  Bregan wields a magical meteor whip, a rare weapon that looked like a grappling hook with blades and chains instead of hooks and ropes."
#copyspr 323 -- "Dwarven Smith"
#hp 90
#str 17
#prot 8
#att 16
#def 15
#prec 13
#enc 2
#ap 10
#mapmove 1
#mr 14
#enc 2
#mor 30
#size 1

#clearmagic
#reinvigoration 2

#supplybonus 100
#maxage 999
#onebattlespell "Army of Lead"
#summon1 323 -- more dwarven smiths
#mountainsurvival
#standard 30
#siegebonus 20
#castledef 20
#expertleader
#noundeadleader
#shockres 25
#fireres 25
#coldres 25
#armor "Stone Shield"
#armor "Marble Breastplate"
#armor "Black Steel Helmet"
#weapon 693 -- meteor whip
#unique
#end




#newmonster 2838
#copystats 323
#name "Dwarven Warrior"
#copyspr 323
#clearmagic
#hp 14
#mor 16
#enc 2
#att 12
#gcost 20
#rcost 0
#weapon 18
#end



--------------------------------------------------------------------------------
-- Gothem
#newmonster 2818
#name "Gothem Firstborn"
#descr "In the dawn of this world, Gothem was the first to awaken, his body born of the bones of the earth.  Before the first elf, dragon, or man opened its eyes, he walked under every sky, on every world, in every plane to explore all the boundless beauty he could find.  Dergoth the Exile was his youngest cousin, another born in that time of dawn but on another plane.  However, Dergoth turned on his birthworld and twisted it into a black, poisoned cinder to feed his own power.  When Dergoth turned his attention to the jewel that was Ea, the world of Antilarium, Gothem returned and fought Dergoth.  Gothem's might broke Dergoth's soul into three pieces, which were cast to the ends of the world.  To protect the world that was his mother, Gothem set himself upon the oldest mountain to guard against the return of Dergoth or any other threat from the outside.  Over the ages, the mountain eroded and his body has settled into the form of a giant unmoving monolith; but his power is undiminished."
#spr1 "./Antilarium/gothem1.tga"
#spr2 "./Antilarium/gothem2.tga"
#hp 75
#prot 30
#mr 15
#str 20
#att 7
#def 5
#prec 15
#ap 2
#enc 1
#mapmove 0
#excellentleader
#excellentmagicleader
#noundeadleader
#mor 50
#restrictedgod 94
#reinvigoration 5
#blind
#weapon 795
#itemslots 28672
#size 3

#magicskill 1 2 -- air
#magicskill 2 2 -- wate
#magicskill 3 4 -- earth
#magicskill 4 4 -- astral
#magicskill 6 4 --nature
#amphibious
#poisonres 100
#coldres 25
#fireres 25

#gemprod 3 1 -- earth

#immortal
#summon1 561 -- earth gnome
#reinvigoration 5
#expertmagicleader
#noundeadleader
#unique
#end


--------------------------------------------------------------------------------
-- Viridian
#newmonster 2819
#name "Viridian of Enkeidorn"
#descr "It is said that Viridian was the first druid, taught magic by Gothem the Firstborn, and came to Antilarium from another world.  He was said to have crafted the Wells of Power to regulate and protect the flows of magic in this world, and prevent that magic from being corrupted or turned against the world itself.  Although he has conquered death, he shuns the world of man to live in repose and contemplation in the company of his silent and ancient teacher."
#copyspr 268-- master drood 
#hp 60
#str 14
#prot 10 
#att 14
#def 14
#mr 18
#prec 18
#enc 2
#ap 12
#mor 30

#magicskill 1 2 -- air
#magicskill 2 1 -- wate
#magicskill 3 3 -- earth
#magicskill 4 4 -- astral
#magicskill 6 4 --nature

#gemprod 6 1 --nature
#regeneration 5
#swampsurvival
#mountainsurvival
#forestsurvival
#weapon "Magic Staff"

#supplybonus 200
#immortal
#reinvigoration 5
--onebattlespell 623 -- mass regen?
#expertmagicleader
#noundeadleader
#unique
#end







#selectmonster 185 --bane, well recruit
#gcost 15
#rcost 0
#end

#selectmonster 561 --dirt gnome, well recruit
#gcost 80
#rcost 20
#end

#selectmonster 411 --med H20 elemental, well recruit
#gcost 60
#rcost 6
#end




#selectmonster 141 --barbarian chief, make tougher
#hp 25
#prot 2
#mor 14
#str 15
#att 13
#def 13
#prec 11
#end


#selectmonster 591 --dragonfly, make buyable
#gcost 1
#rcost 0
#end

--------------------------------------------------------------------------------
#newweapon 692
#name "Orksword" 
#att 1
#def 0
#dmg 6
#dt_normal
#len 2
#rcost 1
#secondaryeffect 50
#end



#newmonster 2802 -- 1998
#name "Ork Soldier"
#descr "Orks are dark-skinned, feral-looking demihumans known for their endurance, aggression and lust for power and war.  Ork armies can be raised quickly, and are inexpensive to equip.  They are innately resistant to poison, and often foul their weapons to cause wounds to poison and fester.  Orks are natural soldiers, but will fight amongst themselves if no opponent can be found."
#spr1 "./Antilarium/ork1.tga"
#spr2 "./Antilarium/ork2.tga"
#gcost 10
#rcost 0
#hp 12
#str 12
#prot 3
#att 14
#mor 13
#def 8
#mr 12
#prec 12
#enc 2
#ap 11
#mapmove 2
#darkvision 20
#swampsurvival
#beserk 2
#poisonres 75
#heal
#nametype 100
#incunrest 1
#reinvigoration 2
#pillagebonus 1
#weapon 692 -- orksword
#armor "Leather Shield"
#armor "Copper Plate"
#armor "Iron Cap"
#size 2
#end


--------------------------------------------------------------------------------
--------------------------------------
#newitem
#weapon "Sun Slayer"
#name "Sword of the Exile" 
#copyspr "Sun Slayer" -- Sun Slayer
#descr "One of the three pieces of the broken soul of Dergoth the Exile, a defeated demigod.  It was generally considered the most destructive of the three since it contained the Exile's corruption and hatred.  The rage within the sword may corrupt the body and mind of the one who bears it."
#constlevel 10
#mainpath 5
#mainlevel 10
#type 2 -- 2hsword
#end

--------------------------------------------------------------------------------
-- Tor
#newmonster 2820
#name "Swordwraith"
#descr "Once an aspiring young human Warrior, Tor's path to corruption began when losing a public duel.  Instead of losing gracefully, he extracted his revenge in a dishonorable and despicable fashion.  Never truly fitting in among the great and noble warriors with whom he adventured, he eventually saw opportunity when his party unburied a lost and powerful artifact - the Sword of the Exile.  The dark discontent and hatred within the Sword called to Tor, resonating deeply within his soul.  Tor stole the Sword and slew many of his companions before escaping.  Over time, the Sword twisted Tor's body into an undying thing neither living nor dead - a Swordwraith.  Together, Tor and the Sword roamed the land, laying destruction and seeking power in the form of the other remaining pieces of the soul of Dergoth."
#spr1 "./Antilarium/tor1.tga"
#spr2 "./Antilarium/tor2.tga"
#hp 100
#str 19
#prot 12
#att 18
#mor 30
#def 12
#prec 10
#enc 1
#ap 15
#mapmove 2
#mor 30
#regen 5
#assassin
#stealthy
#okundeadleader

#clearmagic
#pooramphibian
#reinvigoration 1
#pillagebonus 20
#siegebonus 20
#undead
#supplybonus 50
#maxage 999
#onebattlespell 387 -- darkness
#unique
#end



--------------------------------------------------------------------------------
#newitem
#weapon "Astral Claw" -- Pathor, special weapon, horror claw
#name "Soulclaw"
#copyspr 112
#constlevel 10
#mainpath 5
#type 8 -- misc
#descr "A foul and grotesque talon magically crafted from the ethereal corpse of a dead Horror.  The Claw will grant its bearer an extra psychic attack, which will cause corrupted wounds that may draw the attention of Horrors for the rest of the victim's life."
#end

--------------------------------------
#newmonster 2821
#name "Butcher"
#descr "Pathor is the greatest evil hero of the second age, a champion of orks, trolls, and denizens of places dark, murky, and dangerous.  He himself is of mixed ancestry, with at least some ork and troll blood within.  He personifies cunning, avarice, and ruthlessness as a way of life, manifesting the philosophy that in this world you must take what you want or suffer.  The tales of his exploits where he murdered, tricked, trapped or out-ruthlessed armies, heroes, palidans, and forces of righteousness many times larger than his own armies continue to inspire generations of youth to follow the ways of villainy.  Pathor is a master assassin, skilled blood/death mage and viscious fighter, and his cunning and cruelty knows no bounds."
#copyspr 1035 -- blood marshall
#hp 90
#str 17
#def 17
#prot 8
#att 16
#mr 15
#enc 2
#mor 30
#ap 14
#mapmove 2

#clearmagic
#reinvigoration 5
#regeneration 3

#supplybonus 150
#maxage 999
#stealthy
#assassin
#poisonres 100

#magicskill 5 5 --death
#magicskill 7 5 --blood

#gemprod 5 1 --death

#onebattlespell 738 -- rush of strength
#summon1 2802 --orksies
#wastesurvival
#standard 30
#siegebonus 40
#expertleader
#expertundeadleader
#armor "Spider Armor"
#weapon "SoulClaw"
#unique
#end



--------------------------------------
#newmonster 2822
#name "Kyrrn"
#descr "The feline Shiro race is dying from the world, rarely seen though once they were renowned for their battle prowess and artifice with astral magics.  Rare even among Shiro, his coloring resembles that of a snow leopard and mark him as having noble blood.  More wiry and quick than his brethren, Kyrnn wields a strange magical two-handed sword.  Kyrnn has a violent dislike of open water and the sea, having barely survived his ship sinking in battle as a youth.  He carries a deep sadness and many secrets, and though some say that he is tied to a harsh prophesy none have ever gotten Kyrrn to confess his dark past."
#spr1 "./Antilarium/kyrrn1.tga"
#spr2 "./Antilarium/kyrrn2.tga"
#hp 90
#str 16
#def 24
#prot 8
#att 16
#mr 14
#enc 2
#mor 30
#ap 18
#mapmove 2

#nametype 144
#darkvision 30
#forestsurvival
#mountainsurvival
#wastesurvival
#reinvigoration 5
#supplybonus 150
#maxage 9999
#older 4000
#stealthy
#poisonres 25
#coldres 25
#regeneration 2
#weapon 11 -- Great Sword
#armor "Full Scale Mail"

#onebattlespell 738 -- rush of strength
-- makemonster1 2801 --kitties
#standard 20
#expertleader
#noundeadleader
#nomagicleader
#unique
#end

----------------------------------------------------------------------------
#newmonster 2823
#name "Ancient of the Deep"
#descr "The Ancient is oldest and most powerful of the Mages of the Deep, and knows the darkest secrets of the Basalt City of Atlantis.  The Ancient is a powerful water mage.  Sharks are attracted to battles in which the Ancient participates, and it can assume the form of a terrible Monster Crab when it is sufficiently wounded."
#copyspr 322 -- king of the deeps
#hp 40
#str 15
#def 14
#prot 10
#att 15
#mr 16
#enc 3
#mor 30
#ap 12
#mapmove 2

#amphibian
#darkvision 50
#weapon "Magic Staff"
#nametype 141
#reinvigoration 5
#supplybonus 150
#older 5000
#maxage 9999
#coldres 50
#regeneration 2

#onebattlespell "Shark Attack"
#expertleader
#okundeadleader
#expertmagicleader
#secondshape 2824 -- Monster Crab
#unique
#end


--------------------------------------
#newweapon 705
#name "Giant crab claw"
#dmg 0
#att 1
#def 1
#len 3
#secondaryeffect 453
#dt_normal
#end
--------------------------------------
#newmonster 2824
#name "Monster Crab"
#descr "After a giant crab has survived long enough and feasted upon the flesh of enough drowned gods and heroes, it can grow to enormous proportions.  Monster Crabs rule the ocean floor unchallenged, and even the greatest of sea beasts fear to encounter their fearsome claws and rock-hard shell armor.  Sometimes, Monster Crabs will leave the dark sea bottoms and terrorize coastal lands, as they can survive outside of the water as well.  Sharks are drawn to battles in which the Monster Crab is present.  The Monster Crab can eventually heal afflictions through the process of molting and growing a new shell.  Monster Crabs are fearsome fighters and can withstand the darkest, coldest depths, but are poor researchers."
#spr1 "./Antilarium/monstercrab1.tga"
#spr2 "./Antilarium/monstercrab2.tga"
#hp 110
#str 28
#def 16
#prot 18
#att 15
#mr 18
#enc 0
#mor 30
#ap 16
#mapmove 2

#itemslots 28672
#researchbonus -4
#ambidextrous 3

#nametype 141
#darkvision 50
#amphibian
#wastesurvival
#reinvigoration 5
#supplybonus 150
#maxage 9999
#coldres 50
#heal
#weapon 705
#weapon 705

#okleader
#noundeadleader
#nomagicleader

#firstshape 2823
#unique
#end

--------------------------------------
#newmonster 2850
#name "Monster Crab"
#descr "After a giant crab has survived long enough and feasted upon the flesh of enough drowned gods and heroes, it can grow to enormous proportions.  Monster Crabs rule the ocean floor unchallenged, and even the greatest of sea beasts fear to encounter their fearsome claws and rock-hard shell armor.  Sometimes, Monster Crabs will leave the dark sea bottoms and terrorize coastal lands, as they can survive outside of the water as well.  Sharks are drawn to battles in which the Monster Crab is present.  The Monster Crab can eventually heal afflictions through the process of molting and growing a new shell.  Monster Crabs are fearsome fighters and can withstand the darkest, coldest depths, but are poor researchers."
#spr1 "./Antilarium/monstercrab1.tga"
#spr2 "./Antilarium/monstercrab2.tga"
#hp 110
#str 28
#def 16
#prot 18
#att 15
#mr 18
#enc 0
#mor 30
#ap 16
#mapmove 2

#startdom 1
#pathcost 80
#gcost 35
#itemslots 28672
#researchbonus -4
#ambidextrous 3

#nametype 141
#darkvision 50
#amphibian
#wastesurvival
#reinvigoration 5
#supplybonus 150
#maxage 9999
#coldres 50
#heal
#weapon 705
#weapon 705

#okleader
#noundeadleader
#nomagicleader

#end
----------------------------------------------------------------------------
#newmonster 2825
#name "Ea"
#descr "Ea is the living spirit of the world of Antilarium.  Never before has any worldspirit actively interfered in the wars of men and gods, but Ea has now chosen a people to help depose all Pretenders and protct the world from the terrible scars it received during the previous Pretender ascenscion wars.  Ea is tapped into the flow of raw magic into this plane, and as a result Ea generates astral gems each month and astral mages are strengthened in battles where Ea is present.  While Ea can neither physically attack nor defend itself, its gemlike surface would be most difficult to harm.  Ea can directly communicate and forge items through the hands, minds and voices of its followers."
#spr1 "./Antilarium/worldspirit1.tga"
#spr2 "./Antilarium/worldspirit2.tga"
#hp 40
#mor 30
#mr 18
#str 0
#att 0
#def 0
#prot 25
#prec 14
#ap 4
#mapmove 4
#enc 0
#startdom 1
#pathcost 10
#gcost 75
#size 3

#flying
#amphibian
#blind
#researchbonus 4
#gemprod 4 1 -- astral
#gemprod 3 1 -- earth
#onebattlespell 452 --"Light of the Northern Star"
#inanimate
#weapon "Nothing" -- the one that cancels wapons
#itemslots 28672 -- 3 misc
#noundeadleader
#expertmagicleader
#goodleader
#researchscale 2
#maxage 99999
#clearmagic
#magicskill 4 1 -- astral
#magicskill 3 1 -- earth
#end


----------------------------------------------------------------------------
#newweapon 702
#name "Blackthorn"
#dmg 10
#rcost 6
#len 6
#att 2
#def 1
#aoe 2
#magic
#explspr 10200
#harpooning
#dt_normal
#secondaryeffectalways 63 -- life drain
#end



--------------------------------------
#newmonster 2826
#name "Dergoth the Exile"
#descr "In ages past, Dergoth was a dark being of limitless hunger, hatred and greed that desired to light all the worlds aflame to feed his own power.  However, before he could gain full control over this world, he was defeated and his soul shattered.  However, something of his power and dark ambition remained and grew.  With the rise of the new Pretenders, Dergoth can feel the missing pieces of his soul and has returned to again claim his revenge and dominion over all.  Dergoth is still missing an eye, a hand, and part of his chest.  He is a master of death and astral magics, and in battle he can slowly drain the lifeforce of his enemies.  He is still tied to a world he devoured to gain power, and it provides him two gems per month."
#spr1 "./Antilarium/dergoth1.tga"
#spr2 "./Antilarium/dergoth2.tga"

#hp 50
#mor 30
#str 18
#mr 18
#att 16
#def 16
#prec 15
#prot 8
#ap 18
#mapmove 4
#enc 1
#startdom 2
#pathcost 20
#gcost 100
#size 4

#amphibian
#ethereal
#itemslots 15490 -- less one hand, 2 misc
#eyes 1
#undead
#maxage 9999
#darkvision 100
#expertundeadleader
#goodmagicleader
#goodleader
#onebattlespell "Doom"--"Arcane Domination" --  doesn't seem to work

#weapon 702
#armor "Black Steel Plate"
#armor "Black Steel Helmet"
#gemprod 5 1 -- death
#gemprod 4 1 -- astral
#clearmagic
#magicskill 4 1 -- astral
#magicskill 5 1 -- death
#end


----------------------------------------------------------------------------
#newweapon 703
#name "Warstar"
#dmg 12
#rcost 6
#len 4
#att 4
#def 2
#magic
#dt_normal
#armorpiercing
#end


#newmonster 2827
#name "Shehannon"
#descr "Shehannon was once the living manifestation of Warrior honor and spirit.  Although his powers were limited, he could walk among men and reward warriors of true virtue and punish those whose actions were dishonorable.  He witnessed thousands of battles, but after centuries as the Warrior Avatar he passed his title and responsibilities to another.  He again fights in the wars of gods and mortals, but is now free to champion his own causes and lead his own armies.  He has seen that a new war of Pretenders is beginning that will shake the world, and has set himself to destroying all Pretenders that bring death, ruin, and evil lest they undo all the slow work he has performed guiding the hearts of men.  Shehannon is a peerless combatant and strategist; armies will follow him to the brink of hell but his mastery of magic is limited.  He wields a magical polearm named Warstar that can cut through any armor."
#spr1 "./Antilarium/shehannon1.tga"
#spr2 "./Antilarium/shehannon2.tga"

#hp 75
#mor 30
#str 18
#mr 14
#att 22
#def 18
#prot 0
#prec 17
#ap 16
#mapmove 2
#enc 2
#startdom 1
#pathcost 50
#gcost 0
#size 2

#standard 100
#onebattlespell 344 -- "Quicken Self" 
#okundeadleader
#goodmagicleader
#superiorleader
#maxage 9999
#weapon 703 -- "Warstar"
#armor "Weightless Scale"
#armor "Full Helmet"
#itemslots 64646
#end


----------------------------------------------------------------------------
#newmonster 2828
#copystats 907  -- queen of deep
#name "Queen of the Drowned Lands"
#descr "She resembles a body of dark water with the general appearance of a huge, crowned female being.  The Queen's body is composed of water and is very difficult to harm when she is underwater.  Unless she is completely killed during one combat round, she will heal all her wounds.  She cannot leave the sea."
#copyspr 907 -- elemental queen
#hp 60
#str 19
#def 20
#prot 0
#prec 13
#att 18
#mr 17
#enc 0
#mor 30
#ap 10
#mapmove 2

#darkvision 50
#regeneration 40
#aquatic
#supplybonus 150
#maxage 9999
#coldres 100
#poisonres 100
#magicbeing
#neednoteat
#heal

#goodleader
#noundeadleader
#goodmagicleader
#unique
#end

----------------------------------------------------------------------------
#newweapon 706
#name "Rusty Short Sword" 
#att -1
#def 1
#dmg 4
#rcost 2
#dt_normal
#len 1
#end

#newarmor 302 
#name "Piecemail" 
#prot 8
#def 4
#enc 0
#type 5 -- body
#end

#newarmor 301 
#name "Iron Kettle" 
#prot 14
#def 0
#enc 2
#type 6 -- head
#end

#newmonster 2830
#name "Dwarf-Goblin Hero"
#descr "He is a dwarf-goblin cross of seriously limited intelligence and aspirations of heroism.  He always speaks of himself in the third person, but is nonetheless very brave and ambitious.  He has talked his way into many adventuring parties with stories of the countless evil demihumans he has personally slain, only to have the adventurers eventually realize that Krud had very little grasp of the concepts 'many', 'orks', or even 'slain'.  A typical exit interview would resemble 'HEY, KRUD JUST KILL MANY ORKS!' followed by 'Cripes!  What happened to all of our horses?!?'  Krud met destiny when one of his hapless adventuring parties encountered the Worldspirit, who granted one of their members limitless strength and endurance - and that member happened to be Krud.  Krud wears armor of cookware, horse barding, and any random metal or gear he can find to strap firmly to himself."
#copyspr 272 -- hoburg hero
#hp 12
#prot 4
#enc 0
#ap 10
#mapmove 2
#att 20
#prec 9
#def 10
#str 30
#mr 12
#mor 14
#size 1
#clearmagic

#reinvigoration 10
#weapon 706
#armor "Piecemail" 
#armor "Iron Kettle"
#armor "Buckler"
#noleader
#noundeadleader
#nomagicleader
#unique
#end

----------------------------------------------------------------------------
#newmonster 2831  -- spell bearer, Towers of the Usurper
#copystats 346 -- crystall sorceress
#name "Spellbearer"
#copyspr 346
#onebattlespell "Wind Guide"
#end

#newmonster 2832 -- spell bearer, Towers of the Usurper
#copystats 347 -- crystal priestess
#name "Magicbearer"
#copyspr 347
#onebattlespell "Flaming Arrows"
#end


#newmonster 2835 -- spell bearer, Towers of the Usurper
#copystats 347 -- crystal priestess
#name "Blessingbearer"
#copyspr 347
#onebattlespell "Gaia's Blessing"
#end

----------------------------------------------------------------------------
#newmonster 2833
#name "Sea Witch"
#descr "The Sea Witch is an ancient hag with powers over air, water, and death.  She is ferocious in her vengeance and easily angered, and is feared by sailors and land-dwellers alike.  However, if approached with proper respect and tribute, she has been known to help those in need, particularly sailors, pirates, and others that live on or below the waves."
#copyspr 586 -- Great Hag
#hp 50
#prot 6
#enc 3
#ap 12
#mapmove 2
#prec 14
#att 10
#def 11
#str 20
#mr 18
#mor 22
#size 4

#magicskill death 4
#magicskill water 5
#magicskill air 2
#gemprod death 1
#coldres 75
#poisonres 75
#shockres 75

#female
#amphibious
#onebattlespell "Doom"
#weapon 92 -- bonus curse
#weapon "Quarterstaff"

#startage 1001
#maxage 1000
#poorleader
#poorundeadleader
#poormagicleader
#end

----------------------------------------------------------------------------
#newmonster 2834
#name "Faerie"
#descr "Faerie are small magical beings of nature that infest fields and meadowlands.  They resemble small demihumans with butterfly wings.  While not normally aggressive, if disturbed they can swarm, causing even the largest foes to fall asleep and perhaps never wake up.<CAST GIFT OF REASON TO ENABLE>"
#spr1 "./Antilarium/faerie1.tga"
#spr2 "./Antilarium/faerie2.tga"
#hp 1
#gcost 60
#prot 0
#enc 2
#ap 12
#mapmove 1
#prec 14
#att 12
#def 16
#str 2
#mr 12
#mor 13
#size 1
#itemslots 4096 -- 1 misc

#magicbeing
#flying
#weapon 387 -- sleep touch
#neednoteat
#noleader
#okmagicleader
#noundeadleader
#summon1 2834 -- self kind!  591 -- dragonfly
#end


----------------------------------------------------------------------------
#newweapon 701
#name "Water Strike" 
#att 0
#def 0
#dmg 15
#aoe 1
#range 30
#ammo 10
#dt_normal
#explspr 10119
#flyspr 168 --371 --98 --
#nratt 1
#bonus
#flail
#end

#newweapon 701
#name "Water Strike" 
#att 0
#def 0
#dmg 15
#aoe 1
#range 30
#ammo 10
#dt_normal
#explspr 10119
#flyspr 168 --371 --98 --
#nratt 1
#bonus
#flail
#end

#newweapon 708
#name "Ramming Strike" 
#att 0
#def -1
#dmg 0
#dt_normal
#nostr
#nratt -3
#charge
#onestrike
#end

---------------------------------
#newmonster 2838 -- pretender
#name "Great Sea Mage"
#descr "The Great Sea Mage is an ancient master wizard, with supremacy over water and astral magics."
#spr1 "./Antilarium/seamage1.tga"
#spr2 "./Antilarium/seamage2.tga"

#hp 10
#mor 30
#str 10
#mr 18
#att 10
#def 10
#prot 18
#prec 16
#ap 10
#mapmove 2
#enc 3
#size 2
#coldres 50
#poisonres 50
#darkvision 40
#amphibian

#magicskill 2 1 -- water
#magicskill 4 1 -- astral
#pathcost 80
#amphibian
#weapon 7
#okleader
#startage 290
#maxage 500
#end

---------------------------------
#newmonster 2836 -- pretender
#name "Great Sea Dragon"
#descr "The Great Sea Dragon is the most ancient and wise of all Sea Dragons, the mightiest predators in the sea.  He has discovered the secrets of life and mortality and is worshipped as a god of the ocean.  Although its wings are too think and stubby for flight, they help the Sea Dragon swim like lightning through the open water.  Like all true dragons, it can survive on land as well.  The Great Sea Dragon can emit a powerful jet of water which is very accurate can rend flesh from bones.  The Great Sea Dragon can change into a human form which is more suitable for magical tasks."
#spr1 "./Antilarium/seadragon1.tga"
#spr2 "./Antilarium/seadragon2.tga"

#hp 125
#mor 30
#str 25
#mr 18
#att 15
#def 12
#prot 18
#prec 16
#ap 20
#mapmove 2
#enc 3
#startdom 1
#pathcost 80
#gcost 50
#size 6
#coldres 50
#poisonres 50
#fear 5
#darkvision 40
#amphibian

#magicboost 53 -2

#weapon 20
#weapon 29
#weapon 701 -- squirt

#startage 519
#maxage 1000
#okleader
#shapechange 2838 -- sea mage
#itemslots 12416
#end

---------------------------------
#newmonster 2837
#name "Sea Dragon"
#descr "Sea Dragons are the mightiest predators in the sea; hide is nearly imperveous, and it has a devastating water strike attack in addition to its powerful claws and bite. Sea Dragons are very intelligent, and can sometimes be persuaded to join a cause.  Although its wings are too think and stubby for flight, they help the Sea Dragon swim like lightning through the open water."
#spr1 "./Antilarium/seadragon1.tga"
#spr2 "./Antilarium/seadragon2.tga"

#hp 125
#mor 30
#str 25
#mr 18
#att 15
#def 12
#prot 18
#prec 18
#ap 20
#mapmove 2
#enc 3

#size 6
#coldres 50
#poisonres 50
#fear 5
#darkvision 40
#aquatic

#magicboost 53 -2

#weapon 20
#weapon 29
#weapon 701 -- squirt

#startage 519
#maxage 1000
#okleader
#itemslots 12288
#end



----------------------------------------------------------------------------
#newmonster 2840
#name "Sea Drake"
#descr "Unlike other drakes, Sea Drakes are the immature offspring of true Sea Dragons. While intelligent, they are young and often rash, and can often be convinced to join a cause for the glory or excitement of battle and plunder.  Sea Drakes are amphibious until they grow older and start to develop their swimming wings, and prefer the shallows of coastal regions.  Although they are deadly dangerous and fast in the water, they are slow and clumsy on land.  This awkwardness is compensated by a strong water jet breath weapon they can use only out of the water."
#spr1 "./Antilarium/seadrake1.tga"
#spr2 "./Antilarium/seadrake2.tga"
#gcost 50
#rcost 20
#hp 35
#mor 12
#str 18
#mr 12
#att 12
#def 10
#prot 14
#prec 10
#ap 6
#mapmove 1
#enc 3

#size 4
#coldres 25
#poisonres 25
#amphibian

#weapon 20 -- bite
#weapon 701 -- squirt
#weapon 33 -- claws

#startage 100
#maxage 1000
#poorleader
#itemslots 12288
#watershape 2846
#end

#newmonster 2846
#name "Sea Drake"
#descr "Unlike other drakes, Sea Drakes are the immature offspring of true Sea Dragons. While intelligent, they are young and often rash, and can often be convinced to join a cause for the glory or excitement of battle and plunder.  Sea Drakes are amphibious until they grow older and start to develop their swimming wings, and prefer the shallows of coastal regions.  They have a powerful water strike attack that is only effective above the water."
#spr1 "./Antilarium/seadrake1.tga"
#spr2 "./Antilarium/seadrake2.tga"
#gcost 50
#rcost 20
#hp 35
#mor 16
#str 18
#mr 12
#att 14
#def 14
#prot 14
#prec 10
#ap 18
#mapmove 2
#enc 3

#size 4
#coldres 25
#poisonres 25
#amphibian

#weapon 20
#weapon 33 -- claws
#weapon 300 -- head butt

#startage 100
#maxage 1000
#poorleader
#itemslots 12288
#landshape 2840
#end



----------------------------------------------------------------------------
#newmonster 2841
#name "Tower Master"
#descr "The Tower Masters are the elite, inner circle of mage initiates in the Tower Society.  To qualify for the inner circle, all Tower Masters must master the four fields of magic, melee combat, strategy, and dragon mastery.<CAST GIFT OF REASON TO ENABLE>"
#spr1 "./Antilarium/towermaster1.tga"
#spr2 "./Antilarium/towermaster2.tga"

#gcost 250
#rcost 20
#hp 45
#mor 12
#str 18
#mr 12
#att 12
#def 10
#prot 14
#prec 12
#ap 6
#mapmove 1
#enc 3

#size 4
#coldres 25
#poisonres 25
#amphibian

#weapon 20
#weapon 701 -- squirt
#weapon 12 -- mace

#startage 40
#maxage 52
#poorleader
#itemslots 13446

#magicskill 2 2
#custommagic 35584 100

#goodleader
#goodmagicleader
#itemslots 15494
#end

----------------------------------------------------------------------------
#newmonster 2846
#name "High Mage"
#descr "The Tower Masters are the elite, inner circle of mage initiates in the Tower Society.  They are trained to find dangerous magic and have the ability to scry on faraway provinces.  High Mages are very versatile spellcasters and may be expert in many paths of magic.<CAST GIFT OF REASON TO ENABLE>"
#spr1 "./Antilarium/councilmage1.tga"
#spr2 "./Antilarium/councilmage2.tga"

#gcost 300
#rcost 1
#hp 10
#mor 12
#str 10
#mr 14
#att 10
#def 10
#prot 0
#prec 14
#ap 10
#mapmove 1
#enc 3

#size 2

#weapon 446
#magicskill 52 2 -- sorcery
#magicskill 51 1 -- elemental
#custommagic 49024 75
#custommagic 49024 50
#gemprod 50 1
#researchbonus 1
#older 3

#okleader
#goodmagicleader
#itemslots 15494
#end



----------------------------------------------------------------------------
#newmonster 2842
#copystats 185
#name "Bane Executioner"
#descr "The Bane Executioner is the most feared of all assassins.  It exists only to stalk and execute one victim after another.  Its chilling gaze inspires pure terror, and it wields a terrible bane headsman's axe which will cause wounds to rot and shrivel.  Even well-guarded and powerful commanders must dread these terrible killers, because their stealth and bloodlust is exceeded only by their swiftness and prowess in combat.<CAST GIFT OF REASON TO ENABLE>"
#spr1 "./Antilarium/baneexecutioner1.tga"
#spr2 "./Antilarium/baneexecutioner2.tga"
#gcost 240
#rcost 30
#ap 20
#mapmove 3

#noleader
#poorundeadleader
#fear 1 //not ethereal
#stealthy 20
#assassin
#weapon 707 -- bane blade headsman's axe
#end


#newweapon 707
#name "Bane Headsman's Axe"
#dmg 10
#nratt 1
#att 1
#def 1
#len 3
#dt_normal
#twohanded
#magic
#secondaryeffect 64
#end

----------------------------------------------------------------------------
#newmonster 2843
--#copystats 605 -- son of niefel
-- sadly, this does a crappy job of causing cold scales to increase since the unit doesn't spread dominion, and it also auto-summons winter wolves which is too powerful.
#name "Winterfox"
#descr "The Winterfox is a supernatural creature, born from the coldest nights of the farthest, iciest North and quickened by the Northern Lights and the arctic wind.  It is ethereal and very stealthy, but not aggressive and a poor fighter.  It is said that each year, ethereal Winterfoxes carry Winter trailing from their tails to all corners of the land.  Any province that a Winterfox is in will become colder, until all feel the chill bite of winter in the air. <CAST GIFT OF REASON TO ENABLE>"
#spr1 "./Antilarium/winterfox1.tga"
#spr2 "./Antilarium/winterfox2.tga"
#restrictedgod 23

#gcost 60
#rcost 2
#hp 8
#mor 8
#str 6
#mr 14
#att 10
#def 14
#prot 2
#prec 14
#ap 10
#mapmove 3
#enc 3

#size 1
#coldres 150
#startage 30
#maxage 40
#noleader
#noundeadleader
#okmagicleader
--clearmagic
#magicskill 2 0  -- this is a cheat to allow it to lead magic critters
--magicskill 5 0
#magicboost 2 1
#itemslots 12288
#illusion
#stealthy 20
#weapon 20
#ethereal
#winterpower 1
#cold 6
#magicbeing
#noitem 
#armor "Nothing"
#animal
#coldpower 2
#mountainsurvival
#wastesurvival
#onebattlespell "Grip of Winter"
#end




----------------------------------------------------------------------------
#newmonster 2844
#copystats 323 -- dwarven smith
#name "Dwarven Master Smith"
#descr "Master Smiths are the most experienced and knowledgable of all dwarvenkind.  They have unprecedented ability to forge magic items, and  often also have mastered more than one school of magic to aid in their crafting. <CAST GIFT OF REASON TO ENABLE>"
#copyspr 323
#gcost 400
#rcost 3

#custommagic 16256 100
#custommagic 16256 100
#forgebonus 50
#end





--------------------------------------
#newspell
#name "Sea Dragon Attack"
#descr "The caster summons and sends several mightly sea dragons to attack a distant water province.  Sea Dragons' hides are nearly imperveous, and they have a devastating water strike attack in addition to their powerful claws and bites. This spell may be cast on land."
#school 0
#damage 2837 -- sea dragon
#researchlevel 8
#path 0 2
#pathlevel 0 5
#effect 10038
#nreff 8
#fatiguecost 2000
#spec 276824064
#end 

--------------------------------------
#newspell
#name "Summon Sea Dragon"
#descr "The caster summons a mighty sea dragon to assist in battle.  The Sea Dragon's hide is nearly imperveous, and it has a devastating water strike attack in addition to its powerful claws and bite."
#school 0
#damage 2837 -- sea dragon
#researchlevel 5
#path 0 2
#pathlevel 0 3
#effect 1
#nreff 1
#fatiguecost 500
#spec 33554432
#end 





################################################################################
##   Custom Magic Sites
################################################################################
--------------------------------------------------------------------------------
#newsite 800
#name "Well of Craft" -- Graniteheart
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#com 2844 -- dwarven super smiths
#mon 2838 -- dwarven Warriors
#gems 3 5 -- earth gems
#gems 0 4 -- fire gems
#res 100
#end

----------------------------------
#newsite 801
#name "Well of Clouds" -- monks
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 2805 -- cloud monks
#gems 0 3 -- fire gems
#gems 1 4 -- air gems
#end

----------------------------------
#newsite 802
#name "Well of Exile" -- Tor
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 185 --bane
#com 2842  -- bane executioner
#gems 4 4 -- astral gems
#gems 5 1 -- death gems
#end

----------------------------------
#newsite 803
#name "Well of Hunger" -- Pathor
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#gems 6 5 -- nature gems
#gems 7 1 -- blood gems
#mon 2802 --ork soldiers!
#end

----------------------------------
#newsite 804
#name "Well of Tides"  -- Johann
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 2807 -- sea ranger
#com 1029 -- captain, oh my captain
#gems 1 3 -- water gems
#gems 2 3 -- air gems
#end

----------------------------------
#newsite 805
#name "Well of Fickle Fortune"  -- natasha
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#decscale 4
#gems 1 1 -- air gems
#gems 4 6 -- astral gems
#com 2816 -- fortune priestess
#com 2815 -- bloodwitch
#end

----------------------------------
#newsite 806
#name "Well of Fay"  -- Lester
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#com 2834 -- faerie 
#mon 591 -- dragonfly
#gems 5 5 -- death gems
#gems 6 4 -- nature gems
#end

----------------------------------
#newsite 807
#name "Well of Warriors"  -- cuscraid
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 2839 -- weavework warrior
#gems 3 4 -- earth gems
#gems 6 5 -- nature gems
#res 60
#end

----------------------------------
#newsite 808
#name "Well of Oldest Magic"  -- gothem / mitakka
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#gems 3 4 -- earth gems
#gems 4 6 -- astral gems
#end

----------------------------------
#newsite 809
#name "Well of Ice"  -- winterking
#rarity 5 -- unique
#path 4 -- required to find
#level -- required to find
#loc 511
#decscale 2
#mon 2800 -- thermovore
#com 2843 -- winterfox
#gems 1 3 -- water gems
#gems 4 3 -- astral gems
#end

----------------------------------
#newsite 810
#name "Well of the Protector" -- white tower
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#incscale 0
#mon 2840 -- sea drake
#com 2841 -- tower master
#gems 1 3 -- water gems
#gems 3 4 -- earth gems
#end

----------------------------------
#newsite 811
#name "Well of the Hunter"  -- Kyrnn
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 2801 -- shiro!
#com 2845 -- shiro noble
#gems 1 2 -- air gems
#gems 5 2 -- death gems
#res 40
#end

----------------------------------
#newsite 812
#name "Well of the Usurper" -- Onion
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 2804 -- tower fiend
#gems 0 3 -- fire gems
#gems 4 4 -- astral gems
#end

----------------------------------
#newsite 813
#name "Well of Crushing Depths"  -- Water 1
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 438 --kraken
#gems 1 3 -- water gems
#gems 5 4 -- death gems
#end

----------------------------------
#newsite 814
#name "Well of Currents"  -- water 2
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 411 -- med water elementals
#gems 1 4 -- water gems
#gems 6 3 -- nature gems
#end

----------------------------------
#newsite 815
#name "Well of Agony" -- Vyper 
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#mon 2803 -- agony disciple
#gems 0 4 -- fire gems
#gems 7 2 -- blood gems
#end

----------------------------------
#newsite 816
#name "The Hullsbroken Inn" -- for fun
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#gold 20
#loc 511
#end

----------------------------------
#newsite 817
#name "Tower of the Usurper" -- for fun
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#incscale 5
#loc 511
#end

----------------------------------
#newsite 818
#name "Drowned Throne of Quatombis" -- for fun
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#loc 511
#end

----------------------------------
#newsite 819
#name "High Council of Mitakka" -- for fun
#rarity 5 -- unique
#path 4 -- required to find
#level 1 -- required to find
#com 2847 -- high mage
#res -10
#loc 511
#end

----------------------------------
#newsite 820
#name "The Tavern of the Mad Alchemist" -- for fun
#rarity 5 -- unique
#path 4 -- required to find
#level 0 -- required to find
#gold 20
#loc 511
#end
--------------------------------------------------------------------------------
#end

